package treeNAlgo;

import treeN.*;
import java.util.*;

/**
 * FindNAlgo2 - finds the sub-tree and data position of the given key in the tree
 * 
 * Return value is an Object array where 
 * return[0] is the sub-tree headed by the desired key.  Empty tree if not found.
 * return[1] is the index of the data position of the desired key.  -1 if it was not found.
 */
public class FindNAlgo<E> implements ITreeNAlgo<E, Object[], E> {
  
  private Comparator<E> comp = new Comparator<E>() {
    public int compare(E o1, E o2) {
      return ((Comparable<E>)o1).compareTo(o2);
    }
  };
  
  public FindNAlgo() {
    System.out.println("FindNAlgo instantiated.");
  }
  
  public Object[] caseAt(Integer i, TreeN<E> host, E... key) {
    switch(i) {
      case 0: {
        //System.err.println("Key "+key+" not found in tree.");
        return new Object[]{host, -1};
      }
      default: {
        int x=0;
        for(; x < i; x++) {// find child index
          E d = host.getDat(x);
          int compVal = comp.compare(d, key[0]);
          if(0 == compVal) {
            //System.out.println("Found "+key+"!");
            return new Object[]{host, x};
          } 
          else if (0 < compVal) {
            break;
          }
        }
        return host.getChild(x).execute(this, key);
      }
    }
  }
}
